using System;
using Server;
using Server.Items;
using Server.Network;

namespace Server.Gumps
{
	public class CreditWithdrawGump : Gump
	{
		private CreditCard ccParent;
		
		public CreditWithdrawGump( CreditCard from ) : base( 0, 0 )
		{
			this.Closable=true;
			this.Disposable=true;
			this.Dragable=true;
			this.Resizable=false;
			
			this.AddPage(0);
			this.AddBackground(246, 141, 273, 157, 2600);
			this.AddLabel(325, 160, 0, @"UO Credit Card");
			this.AddLabel(270, 190, 0, @"Enter the amount to withdraw:");
			this.AddImage(302, 215, 2440);
			this.AddButton(320, 250, 247, 248, 1, GumpButtonType.Reply, 0);
			this.AddButton(390, 250, 241, 242, 0, GumpButtonType.Reply, 0);
			this.AddTextEntry(310, 217, 145, 15, 0, 0, @"0");
			
			ccParent = from;
		}
		
		public override void OnResponse( NetState state, RelayInfo info )
		{
			if (info.GetTextEntry(0).Text == "")
			{
				state.Mobile.SendMessage("You did not enter an amount to withdraw.");
				state.Mobile.SendGump( new CreditWithdrawGump( ccParent ) );
				return;
			}
			Mobile m_from = state.Mobile;
			int requestedAmount = Int32.Parse( info.GetTextEntry( 0 ).Text );
			int balance = ccParent.CreditLimit - ccParent.UsedCredit;
			Gold g = new Gold();
			g.Amount = requestedAmount;
			
			if ( info.ButtonID == 1 )
			{
				if ( requestedAmount <= 0 )
				{
					m_from.SendMessage("You did not enter an amount to withdraw.");
					m_from.SendGump( new CreditWithdrawGump( ccParent ) );
					g.Delete();
					return;
				}
				
				if ( balance >= requestedAmount )
				{
					ccParent.UsedCredit = ccParent.UsedCredit + requestedAmount;
					balance = ccParent.CreditLimit - ccParent.UsedCredit;
					m_from.Backpack.DropItem( g );
					m_from.SendMessage("{0} Gold withdrawn.", requestedAmount);
					ccParent.Name = "Credit Card: " + balance;
				}
				else
				{
					m_from.SendMessage("You do not have enough credit on this card.");
					g.Delete();
					return;
				}
			}			
			else
				m_from.SendGump( new CreditCardGump( ccParent ) );
		}
	}
}
